package mole
{
	import net.flashpunk.Engine;
	import net.flashpunk.FP;
	
	/**
	 * Point d'entrée du programme.
	 * @author Cédric Liaudet
	 */
	public class Main extends Engine 
	{		
		/**
		 * Constructeur
		 */
		public function Main():void 
		{
			super(1024, 512, 30, false);
		}
		
		/**
		 * Initialisation du jeu.
		 */
		override public function init():void 
		{
			CONFIG::debug
			{
				FP.console.debug = true;
				FP.console.enable();
			}
			FP.randomizeSeed();
			
			// Initialisation des manageurs.
			FP.world = m_World = new CWorld;
			m_SoundManager = new CSoundManager;			
			m_GameState = new CGameStateManager;
			m_GameRules = new CGameRules;
			m_HUDManager = new CHUDManager;			
		}	
		
		/**
		 * Mise à jours du jeu.
		 */
		override public function update():void
		{
			super.update();
			
			m_GameState.OnUpdate();
			
			m_SoundManager.OnUpdate();
			
			m_GameRules.OnUpdate();
		}

		/**
		 * Acceder au gestionnaire de son.
		 */
		public static function get SoundManager():CSoundManager { return m_SoundManager; }
		
		/**
		 * Acceder au monde.
		 */
		public static function get World():CWorld { return m_World; }
		
		/**
		 * Acceder au gestionnaire d'état de jeu
		 */
		public static function get GameStateManager():CGameStateManager { return m_GameState; }
		
		/**
		 * Acceder au gestionnaire de régle de jeu.
		 */
		public static function get GameRules():CGameRules { return m_GameRules; }
		
		/**
		 * Acceder au gestionnaire de l'interface de jeu.
		 */
		public static function get HUDManager():CHUDManager { return m_HUDManager; }
		
		private static var m_GameState:CGameStateManager; ///< Gestionnaire d'état.
		private static var m_SoundManager:CSoundManager;  ///< Gestionnaire de musique.
		private static var m_World:CWorld;				  ///< Le monde.
		private static var m_GameRules:CGameRules;		  ///< Gestionnaire de régle de jeu.
		private static var m_HUDManager:CHUDManager;	  ///< Gestionnaire de l'interface de jeu.
	}
	
}